define(function () {

    var component = {
        props: ["localnavigation", "closeFoldouts"],
        data: function () {
            return {
                showEdit: false
            };
        },
        created: function () {
            var editButton = document.querySelector("div[data-automationid=SiteHeader] div[data-automationid=HorizontalNav-edit] button");
            if (editButton)
                this.showEdit = true;
        },
        methods: {
            EditLocalNavigation: function () {
                var editButton = document.querySelector("div[data-automationid=SiteHeader] div[data-automationid=HorizontalNav-edit] button");
                if (editButton) {
                    editButton.click();
                    this.closeFoldouts();
                }
            }
        }
    };

    component.originalTemplate = "foldOutLocal";
    component.template = `
<div data-v-0c6fca96 class="foldout foldout-local">
    <ul data-v-0c6fca96 class="column-list">            
        <li data-v-0c6fca96 class="column-listitem" v-for="column in localnavigation" :key="column.Id" v-if="column.Url">
            <div data-v-0c6fca96 class="item-type item-type-heading">                    
                <a data-v-0c6fca96 :href="column.Url">{{column.Title}}</a>
            </div>
            <ul data-v-0c6fca96 class="item-list level1">
                <li data-v-0c6fca96 class="item-listitem" v-for="item in column.Children" :key="item.Id" v-if="item.Url">
                    <div data-v-0c6fca96 class="item-type item-type-link">                            
                        <a data-v-0c6fca96 :href="item.Url">{{item.Title}}</a>                            
                    </div>      
                    <ul data-v-0c6fca96 class="item-list level2">
                        <li data-v-0c6fca96 class="item-listitem" v-for="subitem in item.Children" :key="subitem.Id" v-if="subitem.Url">
                            <div data-v-0c6fca96 class="item-sublistitem-content item-type item-type-link">                                    
                                <a data-v-0c6fca96 :href="subitem.Url">{{subitem.Title}}</a>                            
                            </div>
                        </li>
                    </ul>                  
                </li>
            </ul>
        </li>
    </ul>
    <span data-v-0c6fca96 class="edit" v-if="showEdit" @click="EditLocalNavigation">Edit</span>
</div>
`;
    component.styles = `
.foldout[data-v-0c6fca96] {
  cursor: initial;
  padding-top: 20px;
  padding-left: 30px;
  padding-right: 30px;
  padding-bottom: 20px;
  background-color: "[theme: bodyBackground, default: #ffffff]";
  color: "[theme: themeDarker, default: #282c2e]";
}
.column-list[data-v-0c6fca96], .item-list[data-v-0c6fca96] {
  margin: 0 0 0 0;
  padding: 0 0 0 0;
}
.column-listitem[data-v-0c6fca96] {
  vertical-align: top;
  display: inline-block;
  margin-right: 47px;
}
.item-list[data-v-0c6fca96] {
  line-height: 26px;
}
.item-listitem[data-v-0c6fca96] {
  list-style: none;
}
.item-list.level2[data-v-0c6fca96] {
  margin-left: 12px;
}
.item-type[data-v-0c6fca96] {
  display: block;
  margin-bottom: 10px;
  font-size: 14px;
}
.item-type a[data-v-0c6fca96] {
    color: inherit;
    text-decoration: none;
}
.item-type-heading[data-v-0c6fca96] {
  font-weight: 600;
  text-transform: uppercase;
}
.edit[data-v-0c6fca96] {
  cursor: pointer;
}

/* Hover effect removed because it is not consistent with links other places in Wizdom */


`;

    return component;

});
